/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp3;

import com.google.common.collect.Lists;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.mrp3.EsaSupply;
import cz.insophy.inplan.mrp3.GorSupply;
import cz.insophy.inplan.mrp3.SrSupply;
import cz.insophy.inplan.mrp3.SuppliesCollector;
import cz.insophy.inplan.mrp3.Supply;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.Superplan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DefaultSuppliesCollector
implements SuppliesCollector {
    @Override
    @Nonnull
    public Collection<Supply> collectSupplies(Superplan superplan, Material m3, Collection<Supply> supplies) {
        Supply s2;
        ArrayList<Supply> res = Lists.newArrayList();
        List sas = Lists.newArrayList(superplan.getPlan().getStoreSchedule(StoreType.POSSIBLE_ESTIMATE_VIEW).getActivities(m3)).stream().filter(sa -> sa.getQty() > -1.0E-7).sorted(Comparator.comparingLong(StoreActivity::getTime).thenComparingDouble(StoreActivity::getAbsQty)).collect(Collectors.toList());
        Iterator saIterator = sas.iterator();
        Iterator<Supply> supplyIterator = supplies.iterator();
        StoreActivity sa2 = saIterator.hasNext() ? (StoreActivity)saIterator.next() : null;
        Supply supply = s2 = supplyIterator.hasNext() ? supplyIterator.next() : null;
        while (sa2 != null || s2 != null) {
            if (sa2 != null && s2 != null) {
                if (sa2.getTime() < s2.getTime() || sa2.getTime() == s2.getTime() && sa2.getAbsQty() < s2.getQty()) {
                    res.add(this.createSupply(sa2));
                    sa2 = saIterator.hasNext() ? (StoreActivity)saIterator.next() : null;
                    continue;
                }
                res.add(s2);
                s2 = supplyIterator.hasNext() ? supplyIterator.next() : null;
                continue;
            }
            if (s2 == null) {
                res.add(this.createSupply(sa2));
                sa2 = saIterator.hasNext() ? (StoreActivity)saIterator.next() : null;
                continue;
            }
            res.add(s2);
            s2 = supplyIterator.hasNext() ? supplyIterator.next() : null;
        }
        return res;
    }

    private Supply createSupply(StoreActivity sa) {
        Object originator = sa.getOriginator();
        if (sa instanceof ExternalStoreActivity) {
            return new EsaSupply((ExternalStoreActivity)sa);
        }
        if (originator instanceof SupplyRequest) {
            return new SrSupply((SupplyRequest)originator, sa.getTime(), sa.getAbsQty(), sa.getMaterial());
        }
        if (originator instanceof GeneralizedOrderRequest) {
            return new GorSupply(sa.getTime(), sa.getQty(), sa.getMaterial());
        }
        throw new IllegalStateException("Invalid kind of supply.");
    }
}

